' Kada klasa implementujca interfejs IDescription musi zawiera
' dostpn tylko do odczytu waciwo Description  jej warto
' jest opisem egzemplarza, do ktrego ta waciwo naley. Za
' porednictwem referencji do obiektu, ktry implementuje interfejs
' IDescription, mona uzyska opis tego obiektu. Klasa wykorzystujca
' tak referencj, nie musi zna klasy wskazywanego obiektu.
'
Public Interface IDescription

    ' Opis danego obiektu.
    ReadOnly Property Description() As String
End Interface 'IDescription



' Niniejsza klasa jest modelem danych wykorzystywanym do wywietlania
' opisu obiektu szkieletu.
Public Class DescriptionModel
    ' Obiekt myObject jest wykorzystywany przez klas przegldarki w roli
    ' modelu danych dla opisu jakiego innego obiektu. Referencja do obiektu,
    ' ktrego opis jest udostpniany za porednictwem danego obiektu klasy
    ' DescriptionModel, ma posta wanie zmiennej myObject.
    '
    ' Warto zmiennej myObject jest ustawiana w ciele konstruktora
    ' tego obiektu klasy DescriptionModel. Jeli obiekt przekazany na
    ' wejciu konstruktora nie implementuje interfejsu IDescription,
    ' zmienna myObject bdzie miaa warto null.
    Private myObject As IDescription

    ' Konstruktor
    '
    ' theObject - Obiektobiekt, ktrego opis jest udostpniany przez biecy
    ' obiekt klasy DescriptionModel.
    Public Sub New(ByVal theObject As IDescription)
        myObject = theObject
    End Sub 'New

    ' Opis przegldanego obiektu.
    Public ReadOnly Property Description() As String
        Get
            If myObject Is Nothing Then
                Return "Brak dostpnego opisu"
            End If
            Return myObject.Description
        End Get
    End Property
End Class 'DescriptionModel
